//*****************************************************************************
//
//	File:		 TDotsWindow.cpp
//
//	Description: WindowScreen class playing dominos.
//
//	Copyright 1996, Be Incorporated
//
//  Thanks to Guillaume Desmaret for all the textures and the icon.
//
//*****************************************************************************

#include <stdlib.h>
#include "TDotsWindow.h"
#include "dots.h"

//*********************************************************************

// Index of the blit graphics hook.
#define  INDEX_BLIT   7

// Type definition of the blit graphics hook.
typedef long     (*BLIT)(long,long,long,long,long,long);

#pragma mark --Variables--

static BLIT      blit_jmp;

// dots.c needs to know these
int      drawing_enabled = FALSE;
int      kill_play = FALSE;
int      page_num;
sem_id   lock;
sem_id   ender;
TDotsWindow *window;
long     row;
BRect	 gBounds;

uchar    *draw_base;

// These are only reference by the TDotsWindow
static int       First = TRUE;




#pragma mark --TDotsWindow Class--
//*********************************************************************
// WindowScreen specific stuff.


TDotsWindow::TDotsWindow (uint32 space, char *name, status_t *error):BWindowScreen(name,space, error, false)
{
	BRect   rect;

	if (space == B_8_BIT_800x600)
	{
		gBounds.Set(0,0,800,600);
	}
	else if (space == B_8_BIT_1024x768)
	{
		gBounds.Set(0,0,1024,768);
	}
	else
	{
		gBounds.Set(0,0,640,480);
	}

// create the semaphore
	lock = create_sem(1,"domino lock sem"); 
	ender = create_sem(0,"domino kill sem");

// Initialize Controls
	First = TRUE;
	kill_play = FALSE;
	drawing_enabled = FALSE;

// spawn the domino player thread
	draw = spawn_thread(Play,"Domino player",B_NORMAL_PRIORITY,(void*)this);
	resume_thread(draw);
}


void TDotsWindow::Quit()
{
	Lock();
	Disconnect();

// If the domino player is running, ask for its death and wait for it...
	if (draw != 0L) {
		kill_play = TRUE;
		acquire_sem(ender);
	}
// free the semaphores
	delete_sem(ender);
	delete_sem(lock);
// Quit the WindowScreen.
	BWindowScreen::Quit();
}

void TDotsWindow::ScreenConnected(bool active)
{
	short    height;

	acquire_sem(lock);
	if (active == TRUE) {
		if (First) {
			if (SetFrameBuffer(gBounds.IntegerWidth(), gBounds.IntegerHeight()*2) == B_NO_ERROR)
				goto ok;
			PostMessage(B_QUIT_REQUESTED);
			goto end;
		ok:
			First = FALSE;
		}
		page_num = 0;  // current display : page 0
		MoveDisplayArea(0, 0); // set page 0
		row = CardInfo()->bytes_per_row; // read graphics parameters
		draw_base = (uchar*)CardInfo()->frame_buffer;
		blit_jmp = (BLIT)CardHookAt(INDEX_BLIT);
//		gBounds.Set(0,0,800,600);
		draw_base += gBounds.IntegerHeight()*row; // move the draw_base to the other buffer.
	// allow the drawing in the frame buffer (when lock release).
		drawing_enabled = TRUE;
		clear_buffer(1);
		SwitchBuffer();
		clear_buffer(1);
	}
	else
	// stop drawing.
		drawing_enabled = FALSE;
 end:
// Release the main semaphore.
	release_sem(lock);
}

#pragma mark --Drawing--

// these functions are inline so they are actually located
//	in the header file TDotsWindow.h

/*inline void plot_point(long x, long y,uchar inColor)
{
	if ( gBounds.left <= x && gBounds.right > x+1 && gBounds.top <= y && gBounds.bottom > y+1 )
	{
		*(draw_base + (y * row)+ x ) = inColor;
	}
}

inline void plot_dot(long x, long y,uchar inColor)
{
	uchar *theAdd;
	if ( gBounds.left <= x && gBounds.right > x+2 && gBounds.top <= y && gBounds.bottom > y+2 )
	{
		theAdd = (draw_base + (y * row)+ x );
		*theAdd = inColor;
		*(theAdd+row) = inColor;
		*(theAdd+1) = inColor;
		*(theAdd+row+1) = inColor;
		
	}
}	*/

#pragma mark --Buffer Control--
void clear_buffer(uchar inColor)
{
	uchar *theBuffer = draw_base;
		
	for(;theBuffer < draw_base + row* gBounds.IntegerHeight(); theBuffer++)
	{
		*theBuffer = inColor;
	}
}
void CopyBuffer() 
{
	int      v0,v1;
	
	if (page_num == 0)
	{
		v1 = gBounds.IntegerHeight();
		v0 = 0;
	}
	else
	{	
		v0 = gBounds.IntegerHeight();
		v1 = 0;
	}
	
	(blit_jmp)(0,v0,0,v1,gBounds.IntegerWidth(),gBounds.IntegerHeight());
}

// Switch buffers.
void SwitchBuffer() {
	if (page_num == 0) {
		window->MoveDisplayArea(0, gBounds.IntegerHeight());
		page_num = 1;
		draw_base -= gBounds.IntegerHeight()*row;
	}
	else {
		window->MoveDisplayArea(0, 0);
		page_num = 0;
		draw_base += gBounds.IntegerHeight()*row;
	}
}




